// Procedures globales du projet
// Résumé : Permet de tracer un trajet à partir d'un fichier KML
// Syntaxe :
// GoogleMapsDessineKML (sURL)
//
// Paramètres :
//	sURL  : URL du fichier KML (http://..../<fichier.kml>)
// Valeur de retour :

function AfficheKML(sURL)
{
	var ctaLayer = new google.maps.KmlLayer(sURL);
	ctaLayer.setMap(gObjCarte);
	KMLArray.push(ctaLayer);
	// on renvoie l'objet KMLLayer
	return ctaLayer;
}

// Résumé : Permet de dessiner l'itinéraire entre une adresse de départ et une adresse d'arrivée.
// Syntaxe :
// AfficheItineraireAvecEtape ()
//
// Paramètres :
//	addressStart : // chaine. Correspond à l'adresse de départ
//	adressEnd : // chaine. Correspond à l'adresse d'arrivée
// Valeur de retour :
// 	Aucun : 
//
function AfficheItineraireAvecEtape(addressStart,adressEnd,listeEtapes,aliasAffDetails)
{
	var waypts = [];
	for (i=0;i<listeEtapes.length;i++){
		waypts.push({
			location:listeEtapes[i],
			stopover:true});
	}

	var directions = new google.maps.DirectionsRenderer();
	var directionsService = new google.maps.DirectionsService();
	var request = {
		origin:addressStart, 
		destination:adressEnd,
		waypoints: waypts,
		optimizeWaypoints: true,
		travelMode: google.maps.DirectionsTravelMode.DRIVING
		};
	directionsService.route(request, function(response, status) {
		if (status == google.maps.DirectionsStatus.OK) {
			directions.setDirections(response);
			var route = response.routes[0];
//			var summaryPanel = document.getElementById('directions_panel');
			var summaryPanel = document.getElementById(aliasAffDetails);
			summaryPanel.innerHTML = '';
			// For each route, display summary information.
			for (var i = 0; i < route.legs.length; i++) {
				var routeSegment = i + 1;
				summaryPanel.innerHTML += '<b>Route Segment: ' + routeSegment + '</b><br>';
				summaryPanel.innerHTML += route.legs[i].start_address + ' to ';
				summaryPanel.innerHTML += route.legs[i].end_address + '<br>';
				summaryPanel.innerHTML += route.legs[i].distance.text + '<br><br>';
				}
			}
		});
	directionsArray.push(directions);
	directions.setMap(gObjCarte);
	
	// on renvoie l'objet itinéraire
	return directionsArray;
}
// Récupération de l'objet carte.
function Recupere_API_Carte(obj)
{
	// affectation à la variable globale navigateur.
	gObjCarte = obj;
}

// Affiche un marqueur
function Afficher_Marqueur(nLatitude, nLongitude, sIcone, bDragAndDropAutorise, sTexteInfoClic, nPrecision)
{
	
	if (!gObjCarte)
	return ;
	
	var objCoordonnees;
	var objMarqueur;
	
	// Si la longitude et la latitude sont renseignées, on crée une coordonnée avec ces données
	if (nLatitude && nLongitude)
	{
		objCoordonnees = new google.maps.LatLng(nLatitude, nLongitude)
	}else{
		// si la latitude et la longitude ne sont pas renseignées, on prend le centre de la carte
		objCoordonnees = gObjCarte.getCenter();
	}
	
	if (bDragAndDropAutorise == null)
	bDragAndDropAutorise = true;
	
	// Gestion de l'icône du marqueur
	if(sIcone=="")
	{
		sIcone = null;
	}
	else{
		var tempIcon = {
			url:sIcone
		}
	}
	
	
	// Gestion du cercle de précision
	if (nPrecision != null)
	{
		var options = {
			map:gObjCarte,
			center:objCoordonnees,
			radius:eval(nPrecision),
			fillColor: "#0088FF",
			fillOpacity: 0.2,
			strokeColor: "#0088FF",
			strokeOpacity: 0.5,
			strokeWeight: 1,
			clickable: false
		}
		var cercle = new google.maps.Circle(options);
		circlesArray.push(cercle);
	} 
	
	// Création du marqueur
	// Si on ne spécifie pas cette option, elle ne pourra pas être activée après coup
	var options = {
		draggable:bDragAndDropAutorise,
		position:objCoordonnees,
		map:gObjCarte,
		icon:tempIcon
	};
	// Ajout du marqueur
	objMarqueur = new google.maps.Marker(options); 
	markersArray.push(objMarqueur);
	
	// Ajout de l'info bulle si besoin
	if (sTexteInfoClic) {
		google.maps.event.addListener(objMarqueur, 'click', function() {
			if (!this.getMap()._infoWindow) {
				this.getMap()._infoWindow = new google.maps.InfoWindow();
			}
			this.getMap()._infoWindow.close();
			this.getMap()._infoWindow.setContent(sTexteInfoClic);
			this.getMap()._infoWindow.open(this.getMap(), this);
		});
	}
	
	// On renvoie l'objet marqueur
	return objMarqueur;	
}

var markersArray = [];
var circlesArray = [];
var linesArray = [];
var markerClusterer = null;
var rectangleArray = [];
var polygoneArray = [];
var KMLArray = [];
var directionsArray = [];

// Résumé : Permet de créer des regroupements de marqueurs
// Syntaxe :
// GoogleMapsCreerMarkerClusterer (pts)
//
// Paramètres :
//	pts  : tableau de chaines de caractères. Format : ["46.1206559;4.305847","43.518518;1.559973",etc...]
// Valeur de retour :
// 	Aucune
//
function Marqeur_Clustrer(pts)
{
	Clustererbounds = new google.maps.LatLngBounds();
	gnListemark = [];
	var point = new Array(pts.length);
	for (i=0;i<pts.length;i++){
		var ch = pts[i];
		var tot = ch.split(";");	
		var latLng = new google.maps.LatLng(tot[0],tot[1]);
		var marker = new google.maps.Marker({
			position: latLng,
			draggable: false
		});
		gnListemark.push(marker);
		// mémorise la position : sert à centrer la carte ultérieurement sur l'ensemble du tracé
		Clustererbounds.extend(latLng);
		
	}
	
	var mcOptions = {gridSize: 50, maxZoom: 15};
	markerClusterer = new MarkerClusterer(gObjCarte, gnListemark,mcOptions);
	
	// création de la vue englobant l'ensemble des marqueurs
	gObjCarte.fitBounds(Clustererbounds);
	
	// on renvoie l'objet clusterer
	return markerClusterer;
}


// Résumé : Permet de tracer un trajet sur une carte et de faire parcourir ce tracé par une flèche par exemple.
// Syntaxe :
// GoogleMapsSymbolsAnime (pts)
//
// Paramètres :
//	pts  : Tableau de chaines de caractères. Format ["lat;lng","lat;lng",....]
// Valeur de retour :
// 	Aucune
function Trajet_Anime(pts)
{
	
	PtsBounds = new google.maps.LatLngBounds(); 
	lineCoordinates = [];
	var point = new Array(pts.length);
	for (i=0;i<pts.length;i++){
		var ch = pts[i];
		var tot = ch.split(";");	
		var latLng = new google.maps.LatLng(tot[0],tot[1]);
		
		lineCoordinates.push(latLng);
		// mémorise la position : sert à centrer la carte ultérieurement sur l'ensemble du tracé
		PtsBounds.extend(latLng);
	}
	
	var lineSymbol = {
		path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW,
		scale: 4,
		strokeColor: '#393'
	};
	
	line = new google.maps.Polyline({
		path: lineCoordinates,
		icons: [{
			icon: lineSymbol,
			offset: '200%'
		}],
		map: gObjCarte
	});
	var count = 0;
	offsetId = window.setInterval(function() {
		count = (count + 1) % 200;
		
		var icons = line.get('icons');
		icons[0].offset = (count / 2) + '%';
		line.set('icons', icons);
	}, 40);
	linesArray.push(line);
	// création de la vue englobant le tracé
	//gObjCarte.fitBounds(PtsBounds);
	
	// on renvoie l'objet polyline
	return line;
}

//
// Résumé : Permet de créer des regroupements de marqueurs
// Syntaxe :
// GoogleMapsCreerMarkerClusterer (pts)
//
// Paramètres :
//	pts  : tableau de chaines de caractères. Format : ["46.1206559;4.305847","43.518518;1.559973",etc...]
// Valeur de retour :
// 	Aucune
//
function ClustersClusterer(pts)
{
	Clustererbounds = new google.maps.LatLngBounds();
	gnListemark = [];
	var point = new Array(pts.length);
	for (i=0;i<pts.length;i++){
		var ch = pts[i];
		var tot = ch.split(";");	
		var latLng = new google.maps.LatLng(tot[0],tot[1]);
		var marker = new google.maps.Marker({
			position: latLng,
			draggable: false
		});
		gnListemark.push(marker);
		// mémorise la position : sert à centrer la carte ultérieurement sur l'ensemble du tracé
		Clustererbounds.extend(latLng);
		
	}
	
	var mcOptions = {gridSize: 50, maxZoom: 15};
	markerClusterer = new MarkerClusterer(gObjCarte, gnListemark,mcOptions);
	
	// création de la vue englobant l'ensemble des marqueurs
	gObjCarte.fitBounds(Clustererbounds);
	
	// on renvoie l'objet clusterer
	return markerClusterer;
}




// Affiche une bulle d'information à une position
function AfficheInformation(sTexte, nLatitude, nLongitude)
{
	if (!gObjCarte)
		return ;

	var objCoordonnees;
	// Si la longitude et la latitude sont renseignées, on crée une coordonnée avec ces données
	if (nLatitude && nLongitude)
	{
		objCoordonnees = new google.maps.LatLng(nLatitude, nLongitude)
	}else{
		// si la latitude et la longitude ne sont pas renseignées, on prend le centre de la carte
		objCoordonnees = gObjCarte.getCenter();
	}
	
	var infoWindow = new google.maps.InfoWindow({content: sTexte,position:objCoordonnees});
	
	infoWindow.open(gObjCarte);
}
// Affiche un marqueur
function AfficheMarqueur(nLatitude, nLongitude, sIcone, bDragAndDropAutorise, sTexteInfoClic, nPrecision, nCouleur)
{
	
	if (!gObjCarte)
		return ;

	var objCoordonnees;
	var objMarqueur;
	
	// Si la longitude et la latitude sont renseignées, on crée une coordonnée avec ces données
	if (nLatitude && nLongitude)
	{
		objCoordonnees = new google.maps.LatLng(nLatitude, nLongitude)
	}else{
		// si la latitude et la longitude ne sont pas renseignées, on prend le centre de la carte
		objCoordonnees = gObjCarte.getCenter();
	}
	
	if (bDragAndDropAutorise == null)
		bDragAndDropAutorise = true;
		
	// Gestion de l'icône du marqueur
	if(sIcone=="")
	{
		sIcone = null;
	}
	else{
		var tempIcon = {
			url:sIcone
		}
	}
	
	
	// Gestion du cercle de précision
	if (nPrecision != null)
	{
		var options = {
			map:gObjCarte,
			center:objCoordonnees,
			radius:eval(nPrecision),
			fillColor: nCouleur,
			fillOpacity: 0.2,
			strokeColor: "#2C2C2C",
			strokeOpacity: 0.5,
			strokeWeight: 1,
			clickable: false
		}
		var cercle = new google.maps.Circle(options);
		circlesArray.push(cercle);
	} 
	
	// Création du marqueur
	// Si on ne spécifie pas cette option, elle ne pourra pas être activée après coup
	var options = {
		draggable:bDragAndDropAutorise,
		position:objCoordonnees,
		map:gObjCarte,
		icon:tempIcon
	};
	// Ajout du marqueur
	objMarqueur = new google.maps.Marker(options); 
	markersArray.push(objMarqueur);
	
	// Ajout de l'info bulle si besoin
	if (sTexteInfoClic) {
		google.maps.event.addListener(objMarqueur, 'click', function() {
			if (!this.getMap()._infoWindow) {
				this.getMap()._infoWindow = new google.maps.InfoWindow();
				}
				this.getMap()._infoWindow.close();
				this.getMap()._infoWindow.setContent(sTexteInfoClic);
				this.getMap()._infoWindow.open(this.getMap(), this);
			});
	}
	
	// On renvoie l'objet marqueur
	return objMarqueur;	
}

var markersArray = [];
var circlesArray = [];
var linesArray = [];
var markerClusterer = null;
var rectangleArray = [];
var polygoneArray = [];
var KMLArray = [];
var directionsArray = [];
// Adapte la carte à ses marqueurs
function AdapteZoomEtCentre()
{
	var limits = new google.maps.LatLngBounds();
	for (var i = 0; i < markersArray.length; i++ ) {
		limits.extend(markersArray[i].position);
	}
	gObjCarte.fitBounds(limits);
}
// Affiche une liste de marqueurs (liste fournies au format JSON)
function AfficheMarqueurJSON(sListeCoordJSON)
{
	var Pts= eval(sListeCoordJSON);
	
	var markers = [];
	for (var i = 0; i < Pts.length; i++) {
		var dataPhoto = Pts[i];
		var latLng = new google.maps.LatLng(dataPhoto.xLatitude,dataPhoto.xLongitude);
		var marker = new google.maps.Marker({
			position: latLng,
			map: gObjCarte,
			title: dataPhoto.sReference
			});
		markers.push(marker);
		markersArray.push(marker);
		};
}

// Résumé : Permet de tracer un trajet sur une carte à partir d'une liste de point (Objet JSON)
// Syntaxe :
// afficheTrajetJson (pts)
//
// Paramètres :
//	sListeCoordJSON  : est un objet JSON Format : ["xLatitude":"32.1222","xLongitude":"-1.325"]
// Valeur de retour :
// 	Aucune
//
function afficheTrajetJson(sListeCoordJSON)
{
	var bounds = new google.maps.LatLngBounds();
	var pts= eval(sListeCoordJSON);
	var flightPlanCoordinates= new Array(pts.length);
	for (i=0;i<pts.length;i++){
		var ch = pts[i];	
		var pt = new google.maps.LatLng(ch.xLatitude,ch.xLongitude);
		flightPlanCoordinates[i]=pt;
		// ajoute la liste des points, pour le centrage de la carte
		bounds.extend(flightPlanCoordinates[i]);
		}
	
	var flightPath = new google.maps.Polyline({
		path: flightPlanCoordinates,
		strokeColor: "#FF0000",
		strokeOpacity: 1.0,
		strokeWeight: 2
		});
	
	// affichage du tracé
	flightPath.setMap(gObjCarte);
	// centre la carte sur le tracé
	gObjCarte.fitBounds(bounds);
	gObjCarte.setCenter(bounds.getCenter());
	
	// enregistre dans var. globale pour la suppression
	listeTrajet.push(flightPath);
}

// Centre la carte sur une position
function CentreCarte(nLatitude, nLongitude, nZoom)
{
	if (!gObjCarte)
		return ;
		
	// Si le zoom n'est pas spécifié, on le met à la valeur actuelle
	if (!nZoom)
		nZoom = gObjCarte.getZoom();

	// Bouge la carte pour positionner le centre aux coordonnées données
	gObjCarte.setCenter(new google.maps.LatLng(nLatitude, nLongitude), nZoom);

}
// Résumé : Permet de créer des regroupements de marqueurs
// Syntaxe :
// GoogleMapsCreerMarkerClusterer (pts)
//
// Paramètres :
//	pts  : tableau de chaines de caractères. Format : ["46.1206559;4.305847","43.518518;1.559973",etc...]
// Valeur de retour :
// 	Aucune
//
function AfficheMarqueurClusterer(pts)
{
	Clustererbounds = new google.maps.LatLngBounds();
	gnListemark = [];
	var point = new Array(pts.length);
	for (i=0;i<pts.length;i++){
		var ch = pts[i];
		var tot = ch.split(";");	
		var latLng = new google.maps.LatLng(tot[0],tot[1]);
		var marker = new google.maps.Marker({
			position: latLng,
			draggable: false
			});
		gnListemark.push(marker);
		// mémorise la position : sert à centrer la carte ultérieurement sur l'ensemble du tracé
		Clustererbounds.extend(latLng);
		
		}
	
	var mcOptions = {gridSize: 50, maxZoom: 15};
	markerClusterer = new MarkerClusterer(gObjCarte, gnListemark,mcOptions);
	
	// création de la vue englobant l'ensemble des marqueurs
	gObjCarte.fitBounds(Clustererbounds);
	
	// on renvoie l'objet clusterer
	return markerClusterer;
}

// Résumé : Permet de tracer un trajet sur une carte à partir d'une liste de point
// Syntaxe :
// GoogleMapsTrajet (pts)
//
// Paramètres :
//	pts  : Tableau de chaines de caractères. Format ["xLatitude":"32.1222","xLongitude":"-1.325"]
// Valeur de retour :
// 	Aucune
//
function AfficheTrajet(sListeCoordJSON)
{
	var bounds = new google.maps.LatLngBounds();
	var pts= eval(sListeCoordJSON);
	var flightPlanCoordinates= new Array(pts.length);
	for (i=0;i<pts.length;i++){
		var ch = pts[i];	
		var pt = new google.maps.LatLng(ch.xLatitude,ch.xLongitude);
		flightPlanCoordinates[i]=pt;
		// ajoute la liste des points, pour le centrage de la carte
		bounds.extend(flightPlanCoordinates[i]);
	}
	
	var flightPath = new google.maps.Polyline({
		path: flightPlanCoordinates,
		strokeColor: "#FF0000",
		strokeOpacity: 1.0,
		strokeWeight: 2
		});
	
	
	
//	for (i=0;i<flightPlanCoordinates.length;i++) {
//		bounds.extend(flightPlanCoordinates[i]);
//		}
	
	flightPath.setMap(gObjCarte);
	// centre la carte sur le tracé
	gObjCarte.fitBounds(bounds);
	gObjCarte.setCenter(bounds.getCenter());
	listeTrajet.push(flightPath);
}

// Affiche un tracé sur la carte
function AfficheTrace(nLatitude1, nLongitude1, nLatitude2, nLongitude2,bgedosic,libelleTrace)
{
	
	if (!gObjCarte)
	return ;
	
	var objCoordonnees1;
	var objCoordonnees2;
	var objTrace;
	
	// Si la longitude et la latitude sont renseignées, on crée des coordonnées avec ces données
	if (nLatitude1 && nLongitude2){
		objCoordonnees1 = new google.maps.LatLng(nLatitude1, nLongitude1);
		objCoordonnees2 = new google.maps.LatLng(nLatitude2, nLongitude2)
	}else{
		return ;
	}
	
	if(bgedosic !=null){
		// on fait rien
		}else{
		bgedosic = false
		}
	
	// Création du tracé
	var polyOptions = {
		strokeColor: '#FF0000',
		strokeOpacity: 0.8,
		strokeWeight: 2,
		icons : [{ // utile si pas de libellé
			icon : {
				path : google.maps.SymbolPath.FORWARD_OPEN_ARROW
				},
			offset : '50%'
			}],
		geodesic : bgedosic
	}
	
	// création polyline
	var poly = new google.maps.Polyline(polyOptions);
	var path = poly.getPath();
	// on ajoute les points ou polyline
	path.push(objCoordonnees1);
	path.push(objCoordonnees2);
	
	// centrer la carte sur le tracé
	var boundspoly = new google.maps.LatLngBounds();
	poly.getPath().forEach(function(e){//can't do polyline.getPath()[i] because it's a MVCArray
		boundspoly.extend(e);
		})         
	gObjCarte.fitBounds(boundspoly);
	// affichage
	poly.setMap(gObjCarte);
	// enregistre ce tracé dans variable globale pour la suppression
	linesArray.push(poly);
	
	if(libelleTrace !=''){
		// Affichage du libellé sur le tracé
		// On détermine le milieu du tracé
		inBetween = google.maps.geometry.spherical.interpolate(objCoordonnees1, objCoordonnees2, 0.5);  
		// Création d'un marker invisible
		labelMarker = new google.maps.Marker({  
			position: inBetween,  
			map: gObjCarte,
			visible: false
			});
		// Création d'un libellé
		objCoordonnees1.label = new Label();
		// Position du nouveau marqueur au milieu dans lequel on va afficher un libellé
		objCoordonnees1.label.bindTo('position', labelMarker, 'position');
		// Libellé
		objCoordonnees1.label.set( 'text',libelleTrace);
		// Affichage du libellé
		objCoordonnees1.label.setMap( gObjCarte);
		// enregistre ce libellé dans variable globale pour la suppression
		listeLabel.push(objCoordonnees1);
		}else{
		// on fait rien - affichage du tracé sans le libellé
		}
	
	
	// On renvoie l'objet tracé
	return poly;	
}

// définition des fonctions et prototype. dérive de la classe : google.maps.OverlayView();
// pour l'affichage des libellés sur les tracés (Fonctions AfficheTracé)
function Label(opt_options) {
	// Initialisation
	this.setValues(opt_options);
	
	// Label spécifique
	var span = this.span_ = document.createElement('span');
	span.style.cssText = 'position: relative; left: -50%; top: -8px; ' +
	'white-space: nowrap; border: 1px solid red; ' +
	'padding: 2px; background-color: white';
	
	var div = this.div_ = document.createElement('div');
	div.appendChild(span);
	div.style.cssText = 'position: absolute; display: none';
}
Label.prototype = new google.maps.OverlayView();

// onAdd
Label.prototype.onAdd = function() {
	var pane = this.getPanes().floatPane;
	pane.appendChild(this.div_);
	
	// Assure que le label est redessiné si le texte ou la position change 
	var me = this;
	this.listeners_ = [google.maps.event.addListener(this, 'position_changed',function() { me.draw(); }),	google.maps.event.addListener(this, 'text_changed',function() { me.draw(); })	];
};
//  onRemove
Label.prototype.onRemove = function() {
	var i, I;
	this.div_.parentNode.removeChild(this.div_);
	
	for (i = 0, I = this.listeners_.length; i < I; ++i) {
		google.maps.event.removeListener(this.listeners_[i]);
		}
};

//  draw
Label.prototype.draw = function(e) {
	var projection = this.getProjection();
	var position = projection.fromLatLngToDivPixel(this.get('position'));
	
	var div = this.div_;
	
	div.style.left = position.x + 'px';
	div.style.top = position.y + 'px';
	div.style.display = 'block';
	
	this.span_.innerHTML = this.get('text').toString();
};


// Supprime tout ce qui est affiché sur la carte
function SupprimeTout()
{
	for (var i = 0; i < markersArray.length; i++ ) {
		markersArray[i].setMap(null);
	}
	for (var i = 0; i < circlesArray.length; i++ ) {
		circlesArray[i].setMap(null);
	}
	for (var i = 0; i < linesArray.length; i++ ) {
		linesArray[i].setMap(null);
	}
	for (var i = 0; i < rectangleArray.length; i++ ) {
		rectangleArray[i].setMap(null);
		}
	for (var i = 0; i < polygoneArray.length; i++ ) {
		polygoneArray[i].setMap(null);
		}
	for (var i = 0; i < directionsArray.length; i++ ) {
		directionsArray[i].setMap(null);
		}
	for (var i = 0; i < KMLArray.length; i++ ) {
		KMLArray[i].setMap(null);
		}
	for (var i = 0; i < listeLabel.length; i++ ) {
		listeLabel[i].label.setMap(null);
		}
	for (var i = 0; i < listeTrajet.length; i++ ) {
		listeTrajet[i].setMap(null);
		}
		
	markersArray = [];
	circlesArray = [];
	linesArray = [];
	rectangleArray = [];
	polygoneArray = [];
	directionsArray = [];
	KMLArray = [];
	listeLabel = [];
	listeTrajet = [];
	
	// Si le markerClusterer est renseigné, on le vide
	if (markerClusterer)
	{
		markerClusterer.clearMarkers();
	}
	
	
}

